<?php

namespace App\Http\Controllers\Auth;

use App\Contracts\Controller;
use Illuminate\Foundation\Auth\ResetsPasswords;
use Illuminate\Http\Request;
use Illuminate\View\View;

/**
 * Class ResetPasswordController
 */
class ResetPasswordController extends Controller
{
    use ResetsPasswords;

    protected $redirectTo = '/login';

    /**
     * @param Request $request
     * @param ?string $token
     *
     * @return View
     */
    public function showResetForm(Request $request, ?string $token = null): View
    {
        return view(
            'auth.passwords.reset',
            ['token' => $token, 'email' => $request->email]
        );
    }

    /**
     * Create a new controller instance.
     *
     * @return void
     */
    public function __construct()
    {
        $this->middleware('guest');
    }
}
