<?php

namespace PhpUnitsOfMeasureTest\PhysicalQuantity;

use PhpUnitsOfMeasure\PhysicalQuantity\Angle;

class AngleTest extends AbstractPhysicalQuantityTestCase
{
    protected $supportedUnitsWithAliases = [
        'rad',
        'radian',
        'radians',
        'Yrad',
        'yottaradian',
        'yottaradians',
        'Zrad',
        'zettaradian',
        'zettaradians',
        'Erad',
        'exaradian',
        'exaradians',
        'Prad',
        'petaradian',
        'petaradians',
        'Trad',
        'teraradian',
        'teraradians',
        'Grad',
        'gigaradian',
        'gigaradians',
        'Mrad',
        'megaradian',
        'megaradians',
        'krad',
        'kiloradian',
        'kiloradians',
        'hrad',
        'hectoradian',
        'hectoradians',
        'darad',
        'decaradian',
        'decaradians',
        'drad',
        'deciradian',
        'deciradians',
        'crad',
        'centiradian',
        'centiradians',
        'mrad',
        'milliradian',
        'milliradians',
        'µrad',
        'microradian',
        'microradians',
        'nrad',
        'nanoradian',
        'nanoradians',
        'prad',
        'picoradian',
        'picoradians',
        'frad',
        'femtoradian',
        'femtoradians',
        'arad',
        'attoradian',
        'attoradians',
        'zrad',
        'zeptoradian',
        'zeptoradians',
        'yrad',
        'yoctoradian',
        'yoctoradians',
        'deg',
        '°',
        'degree',
        'degrees',
        'Ydeg',
        'yottadegree',
        'yottadegrees',
        'Zdeg',
        'zettadegree',
        'zettadegrees',
        'Edeg',
        'exadegree',
        'exadegrees',
        'Pdeg',
        'petadegree',
        'petadegrees',
        'Tdeg',
        'teradegree',
        'teradegrees',
        'Gdeg',
        'gigadegree',
        'gigadegrees',
        'Mdeg',
        'megadegree',
        'megadegrees',
        'kdeg',
        'kilodegree',
        'kilodegrees',
        'hdeg',
        'hectodegree',
        'hectodegrees',
        'dadeg',
        'decadegree',
        'decadegrees',
        'ddeg',
        'decidegree',
        'decidegrees',
        'cdeg',
        'centidegree',
        'centidegrees',
        'mdeg',
        'millidegree',
        'millidegrees',
        'µdeg',
        'microdegree',
        'microdegrees',
        'ndeg',
        'nanodegree',
        'nanodegrees',
        'pdeg',
        'picodegree',
        'picodegrees',
        'fdeg',
        'femtodegree',
        'femtodegrees',
        'adeg',
        'attodegree',
        'attodegrees',
        'zdeg',
        'zeptodegree',
        'zeptodegrees',
        'ydeg',
        'yoctodegree',
        'yoctodegrees',
        'arcmin',
        '′',
        'arcminute',
        'arcminutes',
        'amin',
        'am',
        'MOA',
        'arcsecond',
        'arcseconds',
        'arcsec',
        '″',
        'asec',
        'as',
        'yottaarcsec',
        'yottaarcsecond',
        'yottaarcseconds',
        'Yasec',
        'Yas',
        'zettaarcsec',
        'zettaarcsecond',
        'zettaarcseconds',
        'Zasec',
        'Zas',
        'exaarcsec',
        'exaarcsecond',
        'exaarcseconds',
        'Easec',
        'Eas',
        'petaarcsec',
        'petaarcsecond',
        'petaarcseconds',
        'Pasec',
        'Pas',
        'teraarcsec',
        'teraarcsecond',
        'teraarcseconds',
        'Tasec',
        'Tas',
        'gigaarcsec',
        'gigaarcsecond',
        'gigaarcseconds',
        'Gasec',
        'Gas',
        'megaarcsec',
        'megaarcsecond',
        'megaarcseconds',
        'Masec',
        'Mas',
        'kiloarcsec',
        'kiloarcsecond',
        'kiloarcseconds',
        'kasec',
        'kas',
        'hectoarcsec',
        'hectoarcsecond',
        'hectoarcseconds',
        'hasec',
        'has',
        'decaarcsec',
        'decaarcsecond',
        'decaarcseconds',
        'daasec',
        'daas',
        'deciarcsec',
        'deciarcsecond',
        'deciarcseconds',
        'dasec',
        'das',
        'centiarcsec',
        'centiarcsecond',
        'centiarcseconds',
        'casec',
        'cas',
        'milliarcsec',
        'milliarcsecond',
        'milliarcseconds',
        'masec',
        'mas',
        'microarcsec',
        'microarcsecond',
        'microarcseconds',
        'µasec',
        'µas',
        'nanoarcsec',
        'nanoarcsecond',
        'nanoarcseconds',
        'nasec',
        'nas',
        'picoarcsec',
        'picoarcsecond',
        'picoarcseconds',
        'pasec',
        'pas',
        'femtoarcsec',
        'femtoarcsecond',
        'femtoarcseconds',
        'fasec',
        'fas',
        'attoarcsec',
        'attoarcsecond',
        'attoarcseconds',
        'aasec',
        'aas',
        'zeptoarcsec',
        'zeptoarcsecond',
        'zeptoarcseconds',
        'zasec',
        'zas',
        'yoctoarcsec',
        'yoctoarcsecond',
        'yoctoarcseconds',
        'yasec',
        'yas',
    ];

    protected function instantiateTestQuantity()
    {
        return new Angle(1, 'deg');
    }

    public function testToDegrees()
    {
        $angle = new Angle(2 * M_PI, 'rad');
        $this->assertEquals(360, $angle->toUnit('deg'));
    }

    public function testToRadians()
    {
        $angle = new Angle(720, 'degree');
        $this->assertEquals(M_PI * 4, $angle->toUnit('rad'));
    }
}
